#!/bin/bash
 
if let $#'!='3; then
	echo "usage: ftp_test.sh IP ftpcmd_file ftpcmd_file2"
	exit 1
fi

FTP_SERVER=$1
if ! ping -c 1 -w 1 $FTP_SERVER >> /dev/null; then
	echo "$FTP_SERVER not connected with ping."
	exit 1
fi

FTPCMD_FILE=$2
FTPCMD_FILE2=$3
if test ! -s $FTPCMD_FILE; then
	echo "$FTPCMD_FILE not found."
	exit 1
fi

PUT_FILE=`awk '/put /{printf "%s", $2}' $FTPCMD_FILE`
GET_FILE=`awk '/get /{printf "%s", $2}' $FTPCMD_FILE2`
#MASTER_FILE=${PUT_FILE}.MST
MASTER_FILE=$PUT_FILE

COUNT=1
while :
do
	echo `date`
	echo "*** put and get with ftp ***"
	echo "* count: $COUNT"
	echo "* FTP_SERVER: $FTP_SERVER"
	echo "* PUT_FILE: $PUT_FILE"
	echo "* GET_FILE: $GET_FILE"
	echo "****************************"

	ftp -n -v $FTP_SERVER < $FTPCMD_FILE
	ftp -n -v $FTP_SERVER < $FTPCMD_FILE2

	echo "=== compare file ==="
	if cmp -l $MASTER_FILE $GET_FILE; then
		echo "= OK"
		rm -f $GET_FILE
	else
		echo "= NG"
		mv $GET_FILE ${GET_FILE}_NG.bin
		exit 1
	fi
	echo "===================="
	echo ""

	COUNT=`expr $COUNT + 1`
done
