(* 
    Tracing for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(* Trace file descriptor *)
let traceout = ref None

(* Output a trace string *)
let out str =
  match !traceout with
    | Some channel -> Printf.fprintf channel "%s" str; flush channel
    | None -> ()

(* Trace a creation *)
let create data t =
  out (Printf.sprintf "CREATE %s %d\n" t data)

(* Trace a destruction *)
let destroy data t =
  out (Printf.sprintf "DESTROY %s %d\n" t data)

(* Trace I/O *)
let io domain_id prefix time message =
  let message_type = Message.message_type_to_string message.Message.header.Message.message_type
  and sanitised_data = Utils.sanitise_string message.Message.payload in
  out (Printf.sprintf "%s %d %s %s (%s)\n" prefix domain_id time message_type sanitised_data)
