(* 
    Domain info for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

type t;;

external get_crashed32 : t -> int32 = "get_crashed_c";;
external get_domid32 : t -> int32 = "get_domid_c";;
external get_dying32 : t -> int32 = "get_dying_c";;
external get_shutdown32 : t -> int32 = "get_shutdown_c";;
external init : unit -> t = "init_dominfo_c";;
external xc_domain_getinfo : int -> int -> int -> t -> int = "xc_domain_getinfo_c";;

(* Return crashed state *)
let crashed dominfo =
  get_crashed32 dominfo <> 0l

(* Return domain ID *)
let domid dominfo =
  Int32.to_int (get_domid32 dominfo)

(* Return dying state *)
let dying dominfo =
  get_dying32 dominfo <> 0l

(* Return domain info *)
let info dominfo xc_handle id =
  xc_domain_getinfo xc_handle id 1 dominfo

(* Return shutdown state *)
let shutdown dominfo =
  get_shutdown32 dominfo <> 0l
