(* 
    Event channel for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

external fake_call : unit -> int = "xc_interface_open"
external xc_event_chan_bind_interdomain : int -> int -> int -> int = "xc_evtchn_bind_interdomain_c"
external xc_event_chan_bind_virq : int -> int -> int = "xc_evtchn_bind_virq_c"
external xc_event_chan_fd : int -> int = "xc_evtchn_fd_c"
external xc_event_chan_open : unit -> int = "xc_evtchn_open_c"
external xc_event_chan_notify : int -> int -> int = "xc_evtchn_notify_c"
external xc_event_chan_pending : int -> int = "xc_evtchn_pending_c"
external xc_event_chan_unbind : int -> int -> int = "xc_evtchn_unbind_c"
external xc_event_chan_unmask : int -> int -> int = "xc_evtchn_unmask_c"
external xc_interface_open : unit -> int = "xc_interface_open_c"
external xc_interface_close : int -> int = "xc_interface_close_c"

(* XXX: Force libxenctrl to be compiled in. There must be a better way *)
let fake () =
  fake_call ()

let xce_handle = ref (- 1)

(* Bind a domain to the remove end *)
let bind_interdomain id remote_port =
  xc_event_chan_bind_interdomain !xce_handle id remote_port

(* Bind the virq *)
let bind_virq virq =
  xc_event_chan_bind_virq !xce_handle virq

(* Return the event channel fd *)
let get_channel () =
  xc_event_chan_fd !xce_handle

(* Intialise the event channel *)
let init () =
  xce_handle := xc_event_chan_open ()

(* Notify XenBus *)
let notify port =
  ignore (xc_event_chan_notify !xce_handle port)

(* Check for pending event *)
let pending () =
  xc_event_chan_pending !xce_handle

(* Unbind a XenBus port *)
let unbind port =
  xc_event_chan_unbind !xce_handle port <> - 1

(* Unmask a XenBus port *)
let unmask port =
  xc_event_chan_unmask !xce_handle port
