/*
    Event channel C stubs for OCaml XenStore Daemon.
    Copyright (C) 2008 Patrick Colp University of British Columbia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <unistd.h>
#include <xenctrl.h>

#include <caml/mlvalues.h>
#include <caml/callback.h>
#include <caml/memory.h>


/* Bind an interdomain event channel */
value xc_evtchn_bind_interdomain_c (value xce_handle_v, value domid_v, value remote_port_v)
{
    CAMLparam3 (xce_handle_v, domid_v, remote_port_v);

    int xce_handle = Int_val (xce_handle_v);
    int domid = Int_val (domid_v);
    uint32_t remote_port = (uint32_t)(Int_val (remote_port_v));

    CAMLreturn (Val_int (xc_evtchn_bind_interdomain (xce_handle, domid, remote_port)));
}

/* Bind the VIRQ event channel */
value xc_evtchn_bind_virq_c (value xce_handle_v, value virq_v)
{
    CAMLparam2 (xce_handle_v, virq_v);

    int xce_handle = Int_val (xce_handle_v);
    unsigned int virq = Int_val (virq_v);

    CAMLreturn (Val_int (xc_evtchn_bind_virq (xce_handle, virq)));
}

/* Return the event channel file descriptor */
value xc_evtchn_fd_c (value xce_handle_v)
{
    CAMLparam1 (xce_handle_v);

    int xce_handle = Int_val (xce_handle_v);

    CAMLreturn (Val_int (xc_evtchn_fd (xce_handle)));
}

/* Notify an event channel of an event */
value xc_evtchn_notify_c (value xce_handle_v, value port_v)
{
    CAMLparam2 (xce_handle_v, port_v);

    int xce_handle = Int_val (xce_handle_v);
    uint32_t port = (uint32_t)(Int_val (port_v));

    CAMLreturn (Val_int (xc_evtchn_notify (xce_handle, port)));
}

/* Open the event channel */
value xc_evtchn_open_c (value dummy_v)
{
    CAMLparam1 (dummy_v);
    CAMLreturn (Val_int (xc_evtchn_open ()));
}

/* Check an event channel for pending events */
value xc_evtchn_pending_c (value xce_handle_v)
{
    CAMLparam1 (xce_handle_v);

    int xce_handle = Int_val (xce_handle_v);

    CAMLreturn (Val_int (xc_evtchn_pending (xce_handle)));
}

/* Unbind an event channel */
value xc_evtchn_unbind_c (value xce_handle_v, value port_v)
{
    CAMLparam2 (xce_handle_v, port_v);

    int xce_handle = Int_val (xce_handle_v);
    uint32_t port = (uint32_t)(Int_val (port_v));

    CAMLreturn (Val_int (xc_evtchn_unbind (xce_handle, port)));
}

/* Unmask an event channel */
value xc_evtchn_unmask_c (value xce_handle_v, value port_v)
{
    CAMLparam2 (xce_handle_v, port_v);

    int xce_handle = Int_val (xce_handle_v);
    uint32_t port = (uint32_t)(Int_val (port_v));

    CAMLreturn (Val_int (xc_evtchn_unmask (xce_handle, port)));
}

/* Close the XenBus interface */
value xc_interface_close_c (value xc_handle_v)
{
    CAMLparam1 (xc_handle_v);
    CAMLreturn (Val_int (xc_interface_close (Int_val (xc_handle_v))));
}

/* Open the XenBus interface */
value xc_interface_open_c (value dummy_v)
{
    CAMLparam1 (dummy_v);
    CAMLreturn (Val_int (xc_interface_open ()));
}
