#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <debugging.h>


#define input	"microcode.dat"
#define output "microcode.bin"

char * comment_open[] = { "/", "/*", "/+++", NULL };

#define STATE_BOL		0x00
#define STATE_CMNT	0x01
#define STATE_NUM		0x03
#define STATE_WS		0x04
#define STATE_ERR		0x05





int main(int argc, char **argv)
{
	struct stat stb;
	int ifd, ofd, wr;
	char *map, *end, *p, *q;
	int	state	= STATE_BOL;
	int	data;

	unlink(output);

	ofd = open(output, O_WRONLY|O_CREAT, S_IREAD|S_IWRITE);
	if(ofd == -1)
		die("Error opening %s - %m\n", output);

	ifd = open(input, O_RDONLY);
	if(ifd == -1)
		die("Error opening %s - %m\n", input);

	fstat(ifd, &stb);

	map = mmap(NULL, stb.st_size, PROT_READ|PROT_WRITE, MAP_PRIVATE, ifd, 0);
	if(map == (char *)-1)
		die("Error mapping %s - %m\n", input);

	end = map + stb.st_size;

	p = map;

	while(p < end) {
			switch(state) {
				case(STATE_BOL):
				case(STATE_WS):
					if(*p == '0') {
						state = STATE_NUM;
						continue;
					}
					if(*p == '\n') {
						state = STATE_BOL;
						continue;
					}
					if(isspace(*p)) {
						state = STATE_WS;
						p++;
						continue;
					}
					if(*p == '/') {
						state = STATE_CMNT;
						continue;
					}

					state = STATE_ERR;
					continue;
					;;
				case(STATE_CMNT):
					if(*p++ != '\n')
						continue;

					state = STATE_BOL;
					continue;
					;;
				case(STATE_NUM):
					data = strtol(p, &q, 16);
					p = q;

					if(*p++ != ',')
						die("Unexpected character value %d at offset %d\n", *p, p - map - 1);

					wr = write(ofd, &data, sizeof(int));
					if(wr == -1) 
						die("Error writing data word to output file - %m");

					p++;
					state = STATE_WS;

					continue;
					;;
				case(STATE_ERR):
					notice("Error parsing data file at offset %d", p - map);
					break;
					;;
				default:
					die("Unknown state %d", state);
					;;
			}
	}
	
	munmap(map, stb.st_size);

	close(ifd);
	close(ofd);

	exit(0);
}
