/*
    local_types.h


    This file defines convenience data types which are used by a number of
    source files.  It's intent is to provide consistent type sizes for
    programs compiled across different architectures.

*/

#if !defined (LOCAL_TYPES_H)
#define LOCAL_TYPES_H


#if defined(__i386__) || defined(__i486__) || defined(__i586__) || defined(__i686__)
  #include <arch/i386-types.h>
#else
  #if defined(__x86_64)
    #include <arch/x86_64-types.h>
  #else
    #error You need to define types for this architecture.
  #endif
#endif



#endif // LOCAL_TYPES_H

